<?php

namespace Mtc\Realex\Providers;

use Illuminate\Support\Facades\Event;
use Illuminate\Support\ServiceProvider;
use Mtc\Checkout\Events\AddPaymentGatewayScripts;
use Mtc\Realex\Console\Commands\InstallRealex;
use Mtc\Realex\Listeners\AddRealexExternalScripts;
use Mtc\Realex\Realex;

/**
 * Class RealexServiceProvider
 *
 * @package Mtc\Realex
 */
class RealexServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     */
    public function boot()
    {
        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'realex');
        $this->app['payment']->extend('realex', function($app) {
            return new Realex();
        });

        if (!$this->app->runningInConsole()) {
            Event::listen(AddPaymentGatewayScripts::class, AddRealexExternalScripts::class);
        } else {
            $this->publishes([
                dirname(__DIR__, 2) . '/resources/js/public' => public_path('js'),
            ], 'assets');

            $this->publishes([
                dirname(__DIR__, 2) . '/resources/js' => resource_path('js/vendor'),
            ], 'assets');

            $this->commands([
                InstallRealex::class,
            ]);
        }
    }

    /**
     * Register the application services.
     */
    public function register()
    {
        // Automatically apply the package configuration
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/realex.php', 'realex');

    }

}
