<?php

namespace MtcMedia\Queue;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Support\Facades\App;
use Monolog\Logger;

/**
 * Class QueueManager
 * @package MtcMedia\Queue
 */
class QueueManager
{
    /**
     * @return static
     */
    public static function getInstance()
    {
        return App::make(static::class);
    }

    protected $default_queue = 'default';

    /**
     * @var Logger
     */
    protected $logger;

    /**
     * @return Logger
     */
    public function getLogger()
    {
        return $this->logger;
    }

    /**
     * QueueManager constructor.
     * @param Logger $logger
     */
    public function __construct(Logger $logger = null)
    {
        $this->logger = $logger;
    }

    /**
     * @param $name
     * @return Queue
     */
    public function getQueue($name = null)
    {
        if ($name === null) {
            $name = $this->default_queue;
        }

        try {
            $queue = Queue::where('name', '=', $name)->firstOrFail();
        } catch (ModelNotFoundException $e) {
            $queue = $this->createQueue($name);
        }

        $queue->setManager($this);

        return $queue;
    }

    /**
     * @param $name
     * @return Queue
     */
    public function createQueue($name)
    {
        $queue = new Queue();
        $queue->name = $name;
        $queue->save();

        return $queue;
    }

    /**
     * Adds a job to a queue
     * @param $job
     * @param string $queue_name
     */
    public function add($job, $queue_name = null)
    {
        $this->getQueue($queue_name)->addJob($job);
    }


    /**
     * Adds a job to a queue
     * @param $job
     * @param string $queue_name
     */
    public function addSingle($job, $queue_name = null)
    {
        $this->getQueue($queue_name)->addSingle($job);
    }
}
