<?php

namespace MtcMedia\Queue;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class JobModel
 * @package MtcMedia\Queue
 *
 * @property $id
 * @property $queue_id
 * @property $name
 * @property $attempts
 * @property $data
 * @property $created_at
 * @property $updated_at
 * @property $done_at
 */
class JobModel extends Model
{
    protected $table = 'queue_jobs';

    public function scopePending($query)
    {
        return $query->whereNull('done_at');
    }

    /**
     * @return Queueable
     */
    public function getJob()
    {
        $job = unserialize($this->attributes['data']);
        return $job;
    }

    /**
     * Increments the number of attempts on the job model
     *
     * @return int
     */
    public function attempt()
    {
        return $this->increment('attempts');
    }

    /**
     * Marks the job as done
     */
    public function done()
    {
        $this->done_at = Carbon::now();
        $this->save();
    }
}
