<?php

namespace MtcMedia\Queue;

use Illuminate\Support\Facades\DB;
use Queue\Manager;
use Queue\Message;

class Queue
{
    /**
     * @return Manager
     */
    public static function getManager()
    {
        $manager = new Manager();
        $manager->setPdo(DB::getPdo());
        return $manager;
    }

    public static function add(Message $message, $queue_name = 'default')
    {
        static::getManager()->addMessageToQueue($message, $queue_name);
    }

    public static function work($queue_name = 'default')
    {
        static::getManager()->getQueue($queue_name)->execute(1, 1);
    }
}
