<?php
/**
 * Illuminate/Routing
 *
 * @source https://github.com/illuminate/routing
 * @contributor Muhammed Gufran
 * @contributor Matt Stauffer
 * @contributor https://github.com/jwalton512
 * @contributor https://github.com/dead23angel
 */

use Illuminate\Container\Container;
use Illuminate\Events\Dispatcher;
use Illuminate\Routing\Router;

define('LARAVEL_START', microtime(true));
$path = './';
require_once __DIR__ . '/core/includes/header.inc.php';

// Using Illuminate/Events/Dispatcher here (not required); any implementation of
// Illuminate/Contracts/Event/Dispatcher is acceptable
$events = new Dispatcher(app());
/** @var Router $router */
$router = \Illuminate\Support\Facades\App::make(Router::class);

\Illuminate\Support\Facades\App::instance('page_meta', $page_meta);

/** @var \Illuminate\Contracts\Http\Kernel $kernel */
$kernel = \Illuminate\Support\Facades\App::make(Illuminate\Contracts\Http\Kernel::class);

$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

if ($response->getStatusCode() == 404) {
    define('CMS_FALLBACK', true);
    require_once base_path('/core/includes/legacy.php');
    require_once base_path('core/index.php');
    exit;
}
$response->send();

$kernel->terminate($request, $response);
