#!/bin/sh
# Continous Deployment tasks to run when changes are pushed live

# clear old bootstrap cache file manually
rm bootstrap/cache/config.php

# Site migrations
php artisan migrate --force

# Asset compilation
npm install
npm run prod

# Check that Composer is present and generate autoload file
if [ -f ~/public_html/composer.json ]; then
    composer install --no-interaction --no-dev --prefer-dist --optimize-autoloader
else
    echo "Composer files could not be found, you will not get autoloading and dependency management"
fi

# Secondary migrations from package changes
php artisan migrate --force

# Clear caches
php artisan cache:clear
php artisan template:clear
php artisan route:cache
php artisan event:cache
php artisan config:cache

# Cron task setup
cat crons | crontab -
