<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Mtc\Core\Facades\Media;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        $this->bootMedia();
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
    }

    /**
     * Boot Media (image folder) bindings for the application
     *
     * This attaches image_folders from theme to application and adds folders to twig
     */
    protected function bootMedia()
    {
        /*
         * Load image folders from theme (if it exists)
         */
        if (defined('THEME_PATH')) {
            $site_image_folders_path = base_path('/' . THEME_PATH . '/settings/image_folders.php');
            if (file_exists($site_image_folders_path)) {
                Media::addPath($site_image_folders_path);
            }

            $this->app['twig']->addGlobal('image_folders', Media::getFolders());
        }
    }
}
