Vue.component('admin-nav', {
    props: {
        tree: {
            type: Array,
        }
    },
    data: function () {
        return {
            search_query: '',
            open_sections: []
        }
    },
    created: function () {
        if (window.localStorage.admin_nav_open_status && window.localStorage.admin_nav_open_status !== 'false') {
            this.open_sections = JSON.parse(window.localStorage.admin_nav_open_status);
        }
    },
    methods: {
        triggerSection: function (section_name, section_id) {
            if (this.open_sections.indexOf(section_name) !== -1) {
                this.open_sections.splice(this.open_sections.indexOf(section_name), 1);
                $('#' + section_id).slideUp();
            } else {
                this.open_sections.push(section_name);
                $('#' + section_id).slideDown();
            }

            window.localStorage.admin_nav_open_status = JSON.stringify(this.open_sections);
        }
    }
});
