jQuery(function($) {

    $.coordinate_picker = [];

    $.each($('input.coordinates'), function(index, val) {
        $(this).addClass('coordinates-'+index);

        $.coordinate_picker[($(this).attr('id'))] = {settings: {}};

        var coordinates_settings = {
            // Form input element selector for latitude
            lat_selector: 'input.coordinates-'+index,

            // Form input element selector for latitude
            long_selector: 'input.coordinates-'+index,

            starting_query: '78247' // address or zip code
        };

        $.fn.coordinate_picker = function(options) {
            var settings = {
                input: this,
                lat_selector: '#lat',
                long_selector: '#long',
                onComplete: function () {

                },
                starting_query: null
            };
            if (options) {
                $.extend(settings, options);
            }
            $.coordinate_picker[($(this).attr('id'))].settings = settings;

            return this.each(function() {
                var $this = $(this);
                $this.click(function(e) {
                    e.preventDefault();

                    $.smodal({
                        src: '/core/admin/js/libs/coordinate_picker/map.php?input='+settings.input.attr('id'), width: 700, height: 500,
                        input: this
                    }).open();
                });
            });

        };
        $('input.coordinates-'+index).coordinate_picker(coordinates_settings);
    });
});
