/**
 * Vue filter to define decimal format
 * Usage [% item.line_total | decimal(2) %]
 */
Vue.filter('decimal', function (value, digits) {
    return parseFloat(value).toFixed(digits);
});

/**
 * Vue filter to truncate text to a limit
 * Usage [% text | truncate 50 %]
 */
Vue.filter('truncate', function (text, stop, end_style) {
    return text.slice(0, stop) + (stop < text.length ? end_style || '...' : '');
});
