<?php

// Send headers only when the output hasn't started yet
// Only output up to now should be debug dumps
if (headers_sent() === false) {
    header('X-Frame-Options: SAMEORIGIN');
    header('X-XSS-Protection: 1; mode=block');
    header('X-Content-Type-Options: nosniff');
    header('Strict-Transport-Security: max-age=31536000; includeSubdomains');
    header_remove('X-Powered-By');
}

if (!isset($seoadmin) && !defined('CMS_FALLBACK')) {
    $seoadmin = new Seo();
    $seoadmin->getSeoData();
    $page_meta['title'] = $seoadmin->data['title'];
    $page_meta['description'] = $seoadmin->data['description'];
}

// Handle errors
error_reporting(E_ALL ^ E_NOTICE ^ E_STRICT);
ini_set('display_errors', 0);

if (config('app.debug') === true && class_exists(\Whoops\Run::class)) {
    $whoops = new \Whoops\Run;
    $whoops->pushHandler(php_sapi_name() === 'cli' ? new \Whoops\Handler\PlainTextHandler : new \Whoops\Handler\PrettyPageHandler);
    $whoops->register();
}