<?php
/**
 * Main includes file for core
 *
 * @author Andrew Morgan <andrew.morgan@mtcmedia.co.uk>
 */

use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\App;

define('START_TIME', microtime(true));
define('SITE_PATH', dirname(dirname(__DIR__)));

/* Composer Integration */
require_once SITE_PATH . '/vendor/autoload.php';

session_start();

// Bring in settings from DB
$app = require_once SITE_PATH . '/core/includes/container.php';

require_once SITE_PATH . '/core/includes/eloquent.php';

// unsetting the variable to prevent any $app variable collisions
// if you ever need to get the container instance,
// use Illuminate\Support\Facades\App::getInstance(),
// but most of the time App facade should be used.
// Using container via App facade:
// http://laravel.com/docs/4.2/ioc
unset($app);

// Exclude legacy aspects from being loaded always
// E.g. Laravel won't need setting of headers on all requests, just web ones (which are added through middleware)
if (!defined('LARAVEL_START')) {
    require_once SITE_PATH . '/core/includes/legacy.php';
}

/** @var Twig_Environment $twig */
$twig = App::make('twig');
$twig_loader = App::make('twig_loader');

/**
* Register auto loader function located in core/src/helpers.php
*/
spl_autoload_register('__mtc_autoload_classes');

foreach (\Mtc\Core\Providers\CoreModuleServiceProvider::getComponentHooks() as $module_hook) {
    require_once $module_hook;
}

$ga_useragent = \Mtc\Core\Seo\Setting::getSettingValue('GA_USERAGENT');
define('GA_TEST_USERAGENT', $ga_useragent);
if ($ga_useragent && DEV_MODE) {
    $ga_useragent = GA_TEST_USERAGENT;
}
define('GOOGLE_ANALYTICS_USERAGENT', $ga_useragent);

define('HOTJAR_TRACKING_CODE', \Mtc\Core\Seo\Setting::getSettingValue('HOTJAR_TRACKING_CODE'));


if (defined('CMS_ENABLED') && CMS_ENABLED && empty($exclude_header_inc['cms'])) {
    require_once SITE_PATH . '/cms/includes/header.inc.php';
}

if (defined('ABS_ENABLED') && ABS_ENABLED && file_exists(SITE_PATH . '/abs/includes/header.inc.php')) {
    require_once SITE_PATH . '/abs/includes/header.inc.php';
}

if (request()->wantsJson() == false) {
    Mtc\Core\Seo\Redirect::redirectToPage(request()->getPathInfo());
}
$nofollow = DEV_MODE;

/* Admin area authentication */
if (strpos(getcwd() . '/', '/admin/') && php_sapi_name() !== 'cli') {
    if (empty($noauth)) {
        // keep session alive
        if (!empty($_GET['keep_alive'])) {
            session_start();
            exit();
        }

        $adminuser = \Mtc\Core\Gate\Auth::loadUser();
    }
}

foreach (\Mtc\Core\Providers\CoreModuleServiceProvider::getComponentLoaders() as $module_loader) {
    require_once $module_loader;
}

/* Get all user defined settings */
$settings = get_defined_constants(true);
$settings = $settings['user'];

/* Set Global Twig Variables */
$twig->addGlobal('settings', $settings);

if ((defined('ENVIRONMENT') && ENVIRONMENT !== 'production') || $nofollow === true) {
    $page_meta['robots'] ='noindex, nofollow';
} else {
    $page_meta['robots'] ='index, follow';
}


// define $_REQUEST indices for legacy admin checks
if (!isset($_REQUEST['edit'])) {
    $_REQUEST['edit'] = null;
}

if (!isset($_REQUEST['delete'])) {
    $_REQUEST['delete'] = null;
}

if (!isset($_REQUEST['action'])) {
    $_REQUEST['action'] = null;
}

if (!isset($_REQUEST['message'])) {
    $_REQUEST['message'] = null;
}


// Only when not in admin area
if (!strpos(getcwd() . '/', '/admin/') && empty($exclude_header_inc['cross_platform_controller'])) {
    // Cross Platform Controller
    require_once SITE_PATH . THEME_PATH . '/templates/controllers/cross.platform.controller.php';
}

Paginator::currentPageResolver(function () {
    return isset($_REQUEST['page']) ? $_REQUEST['page'] : 1;
});

$args = [
    'twig' => &$twig,
];

HooksAdapter::do_action_ref_array('pre_render_of_page', [$args]);

if (request()->wantsJson() == false) {
    //Add Twig Globals
    $twig->addGlobal('page_meta', $page_meta);
}

/**
 * Image folders on site - Legacy support ONLY!
 *
 * @var array $image_folders
 * @deprecated
 */
$image_folders = \Mtc\Core\Facades\Media::getFolders();
