const mix = require('laravel-mix');

// Get dynamic assets files
require('./resources/js/asset_loader');

/**
 * Mix configuration
 * Building front end and admin side js and less files
 */

mix.version()
    .js('resources/js/admin.js', 'public/js')
    .js('resources/js/app.js', 'public/js')
    .less('resources/less/app.less', 'public/css')
    .less('resources/less/admin.less', 'public/css')
    .less('resources/less/admin_login.less', 'public/css')
    /**
     * Browser sync config
     *
     * No protocol and include www for the urls
     * Afterwards do 'npm run watch' and visit www.FORK_NAME.SITE_NAME.com:3000
     * as per nmp log
     *
     */
    // .browserSync({
    //     proxy: 'www.FORK_NAME.SITE_NAME.com',
    //     host: 'www.FORK_NAME.SITE_NAME.com'
    // })
    .options({
        processCssUrls: false
    });
/**
 * Production config
 * Include babel for better vanilla js support accross browsers
 * Triggered via 'npm run production'
 */
if (mix.inProduction()) {
    let config = mix.config.babel();
    config.cacheDirectory = true;

    mix.webpackConfig({
        module: {
            rules: [{
                test: /\.js?$/,
                exclude: /(node_modules|bower_components)/,
                use: [{
                    loader: 'babel-loader',
                    options: config
                }]
            }]
        }
    });
}
