<?php

namespace App\Console;

use Mtc\Core\Console\Commands\ImageBulkOptimise;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Mtc\Core\Console\Commands\CurrencyUpdate;
use Mtc\Core\Console\Commands\DumpAutoload;
use Mtc\Core\Console\Commands\ImageOptimiseCommand;
use Mtc\Core\Console\Commands\ReuploadCommand;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        //
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        if (defined('ENABLE_CURRENCIES') && ENABLE_CURRENCIES === true) {
            $schedule->command('currency:update')->dailyAt('4:00');
        }

        if (config('queue.default') === 'database') {
            $schedule->command('queue:work --tries=3 --stop-when-empty')
                ->everyMinute()
                ->withoutOverlapping();
        }
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        require base_path('routes/console.php');
    }

}
