<?php

namespace Mtc\PinnedItems\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;

/**
 * @property int $id
 * @property int $owner_id
 * @property string $owner_type
 * @property string $category
 * @property string $pinned_url
 * @property int $pinned_item_id
 * @property string $pinned_item_type
 */
class PinnedItemModel extends Model
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'pinned_items';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'owner_id',
        'owner_type',
        'category',
        'pinned_item_id',
        'pinned_item_type',
        'pinned_url',
        'title',
        'subtitle',
    ];

    protected $visible = [
        'category',
        'pinned_url',
        'title',
        'subtitle',
    ];

    /**
     * Relationship with object that pinned entry
     *
     * @return MorphTo
     */
    public function owner(): MorphTo
    {
        return $this->morphTo('owner');
    }

    /**
     * Relationship with pinned object
     *
     * @return MorphTo
     */
    public function pinnedItem(): MorphTo
    {
        return $this->morphTo('pinned_item');
    }
}
