<?php

namespace Mtc\PinnedItems;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Mtc\PinnedItems\Models\PinnedItemModel;

class PinnedItemRepository
{
    public function __construct(protected array $config)
    {
        //
    }

    public function add(Model $owner, Model $viewed, string $category): void
    {
        PinnedItemModel::query()
            ->updateOrCreate([
                'owner_id' => $owner->id,
                'owner_type' => $owner->getMorphClass(),
                'category' => $category,
                'pinned_item_id' => $viewed->id,
                'pinned_item_type' => $viewed->getMorphClass(),
            ]);
    }

    public function remove(Model $owner, Model $viewed, string $category): bool
    {
        $pin = PinnedItemModel::query()
            ->where([
                'owner_id' => $owner->id,
                'owner_type' => $owner->getMorphClass(),
                'category' => $category,
                'pinned_item_id' => $viewed->id,
                'pinned_item_type' => $viewed->getMorphClass(),
            ])
            ->first();

        if ($pin) {
            return $pin->delete();
        }

        return false;
    }

    public function get(Model $owner, string $category = null, int $count = null): Collection
    {
        return PinnedItemModel::query()
            ->with('pinnedItem')
            ->where('owner_id', $owner->id)
            ->where('owner_type', $owner->getMorphClass())
            ->when($category, fn($query) => $query->where('category', $category))
            ->whereHas('pinnedItem')
            ->when($count, fn($query) => $query->take($count))
            ->latest('updated_at')
            ->get()
            ->map(fn (PinnedItemModel $view) => $view->pinned_item);
    }
}
