<?php

namespace Mtc\PinnedItems\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class PinnedItemModel extends Model
{
    protected $table = 'pinned_items';

    protected $fillable = [
        'owner_id',
        'owner_type',
        'category',
        'pinned_item_id',
        'pinned_item_type',
    ];

    public function owner(): MorphTo
    {
        return $this->morphTo('owner');
    }

    public function pinnedItem(): MorphTo
    {
        return $this->morphTo('pinned_item');
    }
}
