<?php

namespace Mtc\PinnedItems\Facades;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Facade;
use Mtc\PinnedItems\PinnedItemRepository;

/**
 * Class PinnedItem
 *
 * @method static void add(Model $owner, Model $viewed_object, string $category)
 * @method static void remove(Model $owner, Model $viewed_object, string $category)
 * @method static Collection get(Model $owner, string $category, int $limit = null)
 * @see PinnedItemRepository
 */
class PinnedItems extends Facade
{
    protected static function getFacadeAccessor()
    {
        return 'pinned-items';
    }
}
