<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Media Manager Configuration
    |--------------------------------------------------------------------------
    */

    'disk' => 'media',
    'route_prefix' => 'admin/media-manager',
    'middleware' => ['web', 'auth', 'can:access-media-manager'],

    'media_path' => base_path('uploads/media'),
    'media_url'  => env('APP_URL') . '/uploads/media',
    /*
    |--------------------------------------------------------------------------
    | Allowed File Types
    |--------------------------------------------------------------------------
    */
    'allowed_extensions' => [
        'jpg', 'jpeg', 'png', 'webp', 'gif',
        'pdf', 'docx', 'xlsx', 'csv'
    ],

    'allowed_mimes' => [
        'image/jpeg',
        'image/png',
        'image/webp',
        'image/gif',
        'application/pdf',
        'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
        'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
        'text/csv',
        'application/csv',
    ],

    /*
    |--------------------------------------------------------------------------
    | Upload Settings
    |--------------------------------------------------------------------------
    */
    'max_file_size' => 50 * 1024 * 1024, // 50MB
    'max_upload_files' => 50,

    // Max image dimensions (for resizing)
    'image_max_width' => 1920,
    'image_max_height' => 1080,

    // JPEG quality (0–100)
    'jpeg_quality' => 85,

    // Enable/disable auto WebP conversion
    'convert_to_webp' => env('MEDIA_CONVERT_TO_WEBP', false),

    /*
    |--------------------------------------------------------------------------
    | TinyMCE Integration
    |--------------------------------------------------------------------------
    */
    'tinymce_callback' => 'mediaManagerCallback',

    /*
    |--------------------------------------------------------------------------
    | Thumbnail Settings
    |--------------------------------------------------------------------------
    */
    'thumbnail_size' => [
        'width' => 150,
        'height' => 150
    ],
];
