<?php

use Illuminate\Support\Facades\Route;
use Mtc\MediaManager\Http\Controllers\MediaManagerController;

Route::group([
    'prefix' => 'admin',
    'middleware' => 'auth',
], function () {
    Route::group([
        'prefix' => 'media-manager',
    ], function () {
        // Main interface
        Route::get('/', [MediaManagerController::class, 'index'])->name('mediamanager.index');

        // File operations
        Route::get('/browse', [MediaManagerController::class, 'browse'])->name('mediamanager.browse');
        Route::post('/upload', [MediaManagerController::class, 'upload'])->name('mediamanager.upload');
        Route::delete('/delete', [MediaManagerController::class, 'delete'])->name('mediamanager.delete');
        Route::post('/create-folder',
            [MediaManagerController::class, 'createFolder'])->name('mediamanager.create-folder');
        Route::delete('/delete-folder',
            [MediaManagerController::class, 'deleteFolder'])->name('mediamanager.delete-folder');
        Route::post('/delete-multiple',
            [MediaManagerController::class, 'deleteMultiple'])->name('mediamanager.delete-multiple');
        Route::post('/rename', [MediaManagerController::class, 'rename'])->name('mediamanager.rename');

        Route::get('/download', [MediaManagerController::class, 'download'])->name('mediamanager.download');

        // TinyMCE integration
        Route::get('/tinymce', [MediaManagerController::class, 'tinymce'])->name('mediamanager.tinymce');
    });
});