
# 📁 MediaManager Laravel Package

A reusable media manager built for Pharmacy core projects. Features include image/file uploads, folder management, multi-selection, preview modals, optimized uploads, and a modern UI styled with TailwindCSS and Alpine.js.

---

## 🚀 Features

- Drag & drop file uploads
- Create, rename, delete files and folders
- Multi-selection
- Image preview modal
- Toast notifications (success + error)
- File size, extension, and upload limit checks
- TailwindCSS + AlpineJS
- Customizable via config file

---

## 📦 Installation

### Option 1: Install via Composer

```bash
composer require mtcmedia/pharmacy-media-manager
```

Then publish config and assets:

```bash
php artisan vendor:publish --tag=media-manager
```

Ensure `uploads/media/` exists and is writable:
```bash
mkdir -p base_path/uploads/media
chmod -R 755 base_path/uploads/media
```

---

### Option 2: Local Package (for Development)

1. Clone or symlink into `packages/mtcmedia/pharmacy-media-manager` or your custom directory:

2. Update `composer.json` in your main app:
```json
    "repositories": [
        ...
        {
          "type": "path",
          "url": "packages/mtcmedia/pharmacy-media-manager",
          "options": {
            "symlink": true
          }
        }
    ],
```
3. Install the package:
```bash
composer require mtcmedia/pharmacy-media-manager:@dev
```

4. Register service provider (if not auto-discovered):
```php
// config/app.php
'providers' => [
    ...
    \Mtc\MediaManager\Providers\MediaManagerServiceProvider::class,
],
```

5. Run:
```bash
composer dump-autoload
php artisan vendor:publish --tag=media-manager
```

---

## ⚙️ Configuration

After publishing the config file, modify `config/mediamanager.php` based on your setup.

---

## 🗂️ TinyMCE Integration

To use MediaManager with TinyMCE, include the following JavaScript logic **in your own TinyMCE setup**:

```js
tinymce.init({
    selector: 'textarea.simpletinymce',
    ... // your existing config,
    file_picker_callback: function (callback, value, meta) {
        window.insertMediaToTinyMCE = function (url) {
            callback(url);
        };
        window.open('/admin/media-manager/tinymce', 'Media Manager', 'width=950,height=650');
    }
});
```

This ensures the Media Manager opens in a modal and lets you insert media back into the editor.

---

## 🧩 Contributing

Pull requests, improvements, and ideas are always welcome! Clone the project and submit a PR from a branch.

---

## 🛡 Security

Please report any security issues or vulnerabilities.
