<?php

namespace Mtc\PayPalPayments;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\HigherOrderBuilderProxy;
use Mtc\PayPalPayments\Models\PaypalSettingModel;

class PayPalSettingDBRepository
{
    /**
     * Get setting value
     *
     * @param $key
     * @return HigherOrderBuilderProxy|mixed|null
     */
    public function get($key)
    {
        $setting = PaypalSettingModel::query()
            ->where('key', $key)
            ->first();

        if ($setting !== null) {
            return $setting->value ?? $setting->data;
        }
        return null;
    }

    /**
     * Save setting value
     *
     * @param $key
     * @param $value
     */
    public function save($key, $value): void
    {
        if ($value == null) {
            PaypalSettingModel::query()
                ->where('key', $key)
                ->delete();
        }

        if (is_string($value) && strlen($value) <= 191) {
            $update_column = 'value';
        } else {
            $update_column = 'data';
        }

        PaypalSettingModel::query()
            ->updateOrCreate([
                'key' => $key
            ], [
                $update_column => is_array($value) ? json_encode($value) : $value
            ]);
    }

    /**
     * Clear all settings
     */
    public function clearAll(): void
    {
        PaypalSettingModel::query()->truncate();
    }

    /**
     * Clear all setting starting with $pattern
     *
     * @param string $pattern
     */
    public function clearStartingWith(string $pattern): void
    {
        PaypalSettingModel::query()
            ->where('key', 'like', $pattern . '%')
            ->delete();
    }

    /**
     * Check when setting value was updated
     *
     * @param $key
     * @return Carbon
     */
    public function updateTime($key): Carbon
    {
        $setting = PaypalSettingModel::query()
            ->where('key', $key)
            ->first();

        return $setting->updated_at ?? Carbon::now();
    }
}
