<?php

namespace Mtc\PayPalPayments;

use Mtc\Checkout\Contracts\InvoiceRepositoryContract;
use Mtc\Checkout\PaymentForm;

class PayPalCard extends PayPal
{
    /**
     * @param InvoiceRepositoryContract $invoice
     * @param \Mtc\Checkout\Contracts\PayableContract $payable
     * @return bool
     */
    public function isApplicable(InvoiceRepositoryContract $invoice, $payable): bool
    {
        if ($this->settings->readyToTakeCardPayment() === false || $this->settings->cardPaymentsEnabled() === false) {
            return false;
        }

        return parent::isApplicable($invoice, $payable);
    }

    /**
     * @param InvoiceRepositoryContract $invoice
     * @return PaymentForm
     */
    public function getPaymentForm(InvoiceRepositoryContract $invoice): PaymentForm
    {
        return new PaymentForm('paypal-payments-card', 'vue-component', [
            'invoice_id' => $invoice->getId(),
            'name' => __('paypal_payments::paypal.card_payment_option_name'),
        ]);
    }
}
