<?php

namespace Mtc\PayPalPayments\Providers;

use GuzzleHttp\Client;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Route;
use Mtc\Checkout\Events\AddPaymentGatewayScripts;
use Mtc\PayPalPayments\Listeners\AddPayPalPaymentIcon;
use Mtc\PayPalPayments\Listeners\AddPayPalScripts;
use Mtc\PayPalPayments\PayPalSettings;
use Mtc\PayPalPayments\Services\PayPalApi;

class PayPalProvider extends RouteServiceProvider
{
    /**
     * Register Service
     */
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/paypal_payments.php', 'paypal_payments');
        $this->loadViewsFrom(dirname(__DIR__, 2) . '/resources/views', 'paypal');
        $this->loadMigrationsFrom(dirname(__DIR__, 2) . '/database/migrations');
        if ($this->app->runningUnitTests() === false) {
            app('twig_loader')->addPath(dirname(__DIR__, 2) . '/resources/templates');
        }

        parent::register();

        $this->app->singleton(PayPalApi::class, function ($app) {
            $settings = $app->make(PayPalSettings::class);
            return new PayPalApi(
                new Client([ 'timeout' => 3.1 ]),
                $settings->get('API_CLIENT_ID'),
                $settings->get('API_CLIENT_SECRET')
            );
        });
    }

    /**
     * Boot/start service
     *
     * @throws \Illuminate\Contracts\Container\BindingResolutionException
     */
    public function boot()
    {
        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'paypal_payments');

        if (config('paypal_payments.enabled') !== true) {
            return;
        }

        parent::boot();

        Event::listen(AddPaymentGatewayScripts::class, AddPayPalScripts::class);
        Event::listen('checkout.additional_payment_icons', AddPayPalPaymentIcon::class);

        // Unable to boot this in tests due to the dependency complexity
        if ($this->app->runningUnitTests() === false) {
            $this->app['payment']->extend(
                'PayPal',
                function () {
                    return $this->app->make(config('paypal_payments.payment_gateway_class'));
                }
            );
            $this->app['payment']->extend(
                'PayPal-Card',
                function () {
                    return $this->app->make(config('paypal_payments.card_payment_gateway_class'));
                }
            );
        }

        if ($this->app->runningInConsole()) {
            // Publishing assets.
            $this->publishes([dirname(__DIR__, 2) . '/resources/js' => resource_path('js/vendor')], 'assets');
        }
    }

    /**
     * Map routes
     */
    public function map()
    {
        Route::middleware('web')->group(dirname(__DIR__, 2) . '/routes/web.php');
        Route::prefix('api')->middleware('api')->group(dirname(__DIR__, 2) . '/routes/api.php');
    }
}
