<?php

namespace Mtc\PayPalPayments\Listeners;

use Illuminate\Support\Facades\Config;
use Mtc\PayPalPayments\PayPalSettings;
use Mtc\PayPalPayments\Services\PaymentService;

class AddPayPalScripts
{
    /**
     * @var PayPalSettings
     */
    private $settings;

    /**
     * @var PaymentService
     */
    private $service;

    public function __construct(PayPalSettings $settings, PaymentService $service)
    {
        $this->settings = $settings;
        $this->service = $service;
    }

    /**
     * Set the delivery name for order when creating it
     *
     * @param $event
     * @return string
     */
    public function handle($event)
    {
        $merchant_id = $this->settings->get('merchant_id');
        $client_id = $this->settings->get('API_CLIENT_ID');
        $currency = 'GBP';
        $partner_attribution_id = Config::get('paypal_payments.partner_attribution_id');
        $client_token = $this->service->generateClientToken();
        return "<script src='https://www.paypal.com/sdk/js?components=hosted-fields,buttons&client-id={$client_id}"
            . "&merchant-id={$merchant_id}&currency={$currency}&intent=capture'
                data-client-token='{$client_token}'
                data-partner-attribution-id='{$partner_attribution_id}'
                data-merchant-id='{$merchant_id}'></script>";
    }
}
