<?php

namespace Mtc\Paypal\Listeners;

use Illuminate\Support\Facades\App;
use Mtc\Basket\Contracts\BasketRepositoryInterface;

/**
 * Class AddPayPalButtonToBasket
 * @package Mtc\Stripe\Listeners
 */
class AddPayPalButtonToBasket
{

    /**
     * Set the delivery name for order when creating it
     *
     * @param BasketRepositoryInterface $basket
     */
    public static function handle(BasketRepositoryInterface $basket)
    {
        if (App::make(config('paypal.applicable_check_class'))->handle($basket)) {
           $basket->setExternalGateway('paypal_ec', template(config('paypal.button_template')));
        }
        return null;
    }
}
