<?php

namespace Mtc\Paypal\Http\Resources;

use Illuminate\Http\Request;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\Foundation\Country;
use Mtc\Basket\Address;
use Mtc\Foundation\Http\Resources\CountryList;
use Mtc\ShippingManager\Facades\Shipping;

/**
 * Class PayPalTemplateResponses
 *
 * @package Mtc\Paypal
 */
class PayPalTemplateResponses
{
    /**
     * Authorize payment
     *
     * @param Request $request
     * @param BasketRepositoryInterface $basket
     * @return string
     */
    public function authorize(Request $request, BasketRepositoryInterface $basket)
    {
        $countries = Country::query()
            ->with('states')
            ->where('status', 1)
            ->get();

        $address = Address::$blueprint;
        $address['country'] = config('foundation.primary_country');

        // Load up authorization step
        return template('paypal_express/authorize.twig', [
            'basket' => $basket,
            'countries' => new CountryList($countries),
            'empty_address' => $address,
            'payment_id' => $request->input('paymentId'),
            'payer_id' => $request->input('PayerID'),
            'token' => $request->input('token'),
            'charge_url' => route('paypal.charge'),
            'hide_inputs' => true,
            'shipping_types' => Shipping::enabledTypes(),
            'collect_locations' => Shipping::collectLocations($basket),
        ]);
    }
}
