<?php

namespace Mtc\Orders;

use Illuminate\Database\Eloquent\Model;

/**
 * Class IntegrationHistory
 *
 * @package Mtc\Orders
 */
class IntegrationHistory extends Model
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'order_integration_history';

    /**
     * Columns that cannot be mass assigned
     *
     * @var array
     */
    protected $guarded = [
        'id'
    ];

    /**
     * Cast variables to types
     *
     * @var array
     */
    protected $casts = [
        'processed_at' => 'datetime',
        'failed_at' => 'datetime',
    ];


    /**
     * Relationship with order
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function order()
    {
        return $this->belongsTo(config('orders.order_class'));
    }
}
