<?php

namespace Mtc\Orders\Http\Presenters;

use Illuminate\Contracts\Support\Arrayable;
use Mtc\Orders\OrderShipmentBox;

/**
 * Class OrderShipmentBoxUrlPresenter
 *
 * @package Mtc\Orders
 */
class OrderShipmentBoxUrlPresenter implements Arrayable
{
    /**
     * @var OrderShipmentBox
     */
    protected $box;

    /**
     * OrderShipmentBoxUrlPresenter constructor.
     *
     * @param OrderShipmentBox $box
     */
    public function __construct(OrderShipmentBox $box)
    {
        $this->box = $box;
    }

    /**
     * Accessor
     *
     * @param $key
     * @return mixed
     */
    public function __get($key)
    {
        if (method_exists($this, $key)) {
            return $this->$key();
        }

        return $this->$key;
    }

    /**
     * Add support for conversion to array
     *
     * @return array
     */
    public function toArray()
    {
        return [
            'update' => $this->update(),
            'destroy' => $this->destroy()
        ];
    }

    /**
     * Update route
     *
     * @return string
     */
    public function update()
    {
        return route('order.shipment-boxes.update', [ $this->box->shipment_id, $this->box->id ]);
    }

    /**
     * Destroy route
     *
     * @return string
     */
    public function destroy()
    {
        return route('order.shipment-boxes.destroy', [ $this->box->shipment_id, $this->box->id ]);
    }
}
