<?php

namespace Mtc\Orders;

use Illuminate\Database\Eloquent\Model;
use Mtc\Money\Price;

class Line extends Model
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'order_item_lines';

    /**
     * Columns that cannot be mass assigned
     *
     * @var array
     */
    protected $guarded = [
        'id'
    ];

    /**
     * @var array
     */
    public $show_in_details = [
        'sku',
        'name',
        'paid_price'
    ];

    /**
     * When saved touch an update of a relationship
     *
     * @var array
     */
    protected $touches = [
        'item'
    ];

    /**
     * Relationship with Order Item
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function item()
    {
        return $this->belongsTo(Item::class);
    }

    /**
     * unit_price as Price object
     *
     * @return Price
     */
    public function getUnitPriceAttribute(): Price
    {
        return new Price($this->attributes['unit_price'], $this->vat_rate);
    }

    /**
     * paid_price as Price object
     *
     * @return Price
     */
    public function getPaidPriceAttribute(): Price
    {
        return new Price($this->attributes['paid_price'], $this->vat_rate);
    }

    /**
     * Glue together all detail fields in a single string
     *
     * @return string
     */
    public function getDetailsAttribute()
    {
        return collect($this->only($this->show_in_details))->implode(' - ');
    }
}
