<?php

namespace Mtc\Orders;

use Illuminate\Database\Eloquent\Model;
use Mtc\Orders\Http\Presenters\OrderShipmentBoxUrlPresenter;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class OrderShipmentBox
 *
 * @package Mtc\Orders
 */
class OrderShipmentBox extends Model
{
    use SoftDeletes;

    /**
     * Mass assignable attributes
     *
     * @var array
     */
    protected $fillable = [
        'shipment_id',
        'weight',
        'box_id',
    ];

    /**
     * Append attribute to json
     *
     * @var array
     */
    protected $appends = [
        'editable',
        'url',
    ];

    /**
     * Relationship with Shipment
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function shipment()
    {
        return $this->belongsTo(OrderShipment::class);
    }


    /**
     * Relationship with box used for the shipment
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function box()
    {
        return $this->belongsTo(ShipmentBox::class, 'box_id');
    }

    /**
     * editable attribute
     *
     * @return bool
     */
    public function getEditableAttribute()
    {
        return false;
    }

    /**
     * Box route urls
     *
     * @return OrderShipmentBoxUrlPresenter
     */
    public function getUrlAttribute()
    {
        return new OrderShipmentBoxUrlPresenter($this);
    }
}
