<?php

namespace Mtc\Orders\Listeners;

use Mtc\Orders\Events\FetchOrderProcessingActions;
use Mtc\Orders\Events\OrderPaid;

/**
 * Class ResendOrderConfirmationEmail
 *
 * @package Mtc\Orders
 */
class ResendOrderConfirmationAction
{
    /**
     * Handle the event.
     *
     * @param OrderPaid $event
     * @return array
     */
    public function handle(FetchOrderProcessingActions $event)
    {
        return [
            'name' => 'Resend Order Confirmation',
            'action' => route('orders.send_confirmation', [$event->getOrder()->id]),
            'method' => 'post'
        ];
    }

}
