<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddDeletedColumnToOrderShipments extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('order_shipments', function (Blueprint $table) {
            $table->softDeletes();
        });

        Schema::table('order_shipment_items', function (Blueprint $table) {
            $table->softDeletes();
        });

        Schema::table('order_shipment_boxes', function (Blueprint $table) {
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('order_shipments', function (Blueprint $table) {
            $table->dropSoftDeletes();
        });

        Schema::table('order_shipment_items', function (Blueprint $table) {
            $table->dropSoftDeletes();
        });

        Schema::table('order_shipment_boxes', function (Blueprint $table) {
            $table->dropSoftDeletes();
        });
    }
}
