<?php

namespace Mtc\Orders;

use Illuminate\Database\Eloquent\Model;

/**
 * Class History
 *
 * @package Mtc\Orders
 */
class History extends Model
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'order_history';

    /**
     * History levels
     *
     * @var array
     */
    public static $levels = [
        'success' => 'fas fa-check',
        'warning' => 'fas fa-exclamation',
        'error' => 'fas fa-exclamation-triangle',
    ];

    /**
     * Columns that cannot be mass assigned
     *
     * @var array
     */
    protected $guarded = [
        'id'
    ];

    /**
     * Relationship with order
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function order()
    {
        return $this->belongsTo(config('orders.order_class'));
    }

}
