<?php

namespace Mtc\Orders;

/**
 * Class Address
 *
 * Order address model
 *
 * @package Mtc\Orders
 */
class Address extends \Mtc\Foundation\Address
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'order_addresses';

    /**
     * Columns that cannot be mass assigned
     *
     * @var array
     */
    protected $guarded = [
        'id',
        'order_id',
        'basket_id',
        'owner_country',
    ];

    /**
     * When saved touch an update of a relationship
     *
     * @var array
     */
    protected $touches = [
        'order'
    ];

    /**
     * Relationship with Order
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function order()
    {
        return $this->belongsTo(config('orders.order_class'));
    }

}
