<?php

namespace Mtc\Orders\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Mtc\Orders\Contracts\OrderContract;
use Mtc\Orders\Contracts\OrderEvent;

class OrderPaid implements OrderEvent
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * @var OrderContract
     */
    protected $order;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(OrderContract $order)
    {
        $this->order = $order;
    }
    /**
     * @return OrderContract
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new PrivateChannel('channel-name');
    }
}
