<?php

use Mtc\Orders\Http\Controllers\Admin\ShipmentController;

return [

    /*
    |--------------------------------------------------------------------------
    | Use Discounts Per Item Line
    |--------------------------------------------------------------------------
    |
    | True: discounted_price is calculated and stored per item line
    | False: discounted_price is not calculated and is not stored per item line
    |
    */
    'use_discounts_per_item_line' => true,

    /*
    |--------------------------------------------------------------------------
    | Class Bindings
    |--------------------------------------------------------------------------
    |
    | Allow changing base classes for implementation
    | Order class represents order model
    | Order Factory is used to Generate Order from Basket
    | Order Repository is a Repository that stores information about a single order
    |
    */
    'order_class' => \Mtc\Orders\Order::class,
    'order_factory' => \Mtc\Orders\Factories\OrderFactory::class,
    'order_repository' => \Mtc\Orders\OrderRepository::class,
    'mark_paid_listener' => \Mtc\Orders\Listeners\MarkOrderPaidFromInvoice::class,

    /*
    |--------------------------------------------------------------------------
    | Service bootstrap
    |--------------------------------------------------------------------------
    |
    | Allow changing event and routing service providers to customize functionality
    |
    */
    'events' => \Mtc\Orders\Providers\OrderEventServiceProvider::class,
    'routing' => \Mtc\Orders\Providers\OrderRouteServiceProvider::class,

    /*
    |--------------------------------------------------------------------------
    | Status action bindings
    |--------------------------------------------------------------------------
    |
    | Since we are seeding order statuses we cannot guarantee they will be consistent
    | Instead we assign status ids here to make sure we can call actions based on config values
    |
    */
    'statuses' => [
        'confirmed' => 1,
        'shipped' => 3,
        'part-shipped' => 4,
        'part-refunded' => 5,
        'refunded' => 6,
        'cancelled' => 8,
    ],

    'only_show_print_invoice_on_statuses' => [
        // Blank for all statuses
    ],

    /*
    |--------------------------------------------------------------------------
    | Terminal statuses
    |--------------------------------------------------------------------------
    |
    | These statuses won't allow user to change status anymore
    |
    */
    'terminal_statuses' => [
        'cancelled',
    ],

    /*
    |--------------------------------------------------------------------------
    | Stock Deduction
    |--------------------------------------------------------------------------
    |
    | Change to false to disable automatic stock deduction when order is
    | marked as paid
    |
    */

    'deduct_stock_after_order_is_paid' => true,

    /*
    |--------------------------------------------------------------------------
    | Order Reference settings
    |--------------------------------------------------------------------------
    |
    | Change the way how order reference is set for order.
    | Order reference prefix will be used only when payment reference is not used.
    |
    */

    'use_payment_reference_for_order_reference' => false,
    'order_reference_prefix' => '',

    /*
    |--------------------------------------------------------------------------
    | Manual Orders
    |--------------------------------------------------------------------------
    |
    | Configuration for manual orders
    |
    */

    'manual_order_applicable_check_class' => \Mtc\Orders\ManualOrderPaymentApplicableCheck::class,
    'manual_order_reference_prefix' => '',

    /*
    |--------------------------------------------------------------------------
    | Admin settings
    |--------------------------------------------------------------------------
    |
    | Settings for admin side functionality
    |
    */

    'admin' => [
        'pagination' => 25,
        'manual_orders' => true,
        'order_editing' => true,
        'routing' => [
            'set_status' => \Mtc\Orders\Http\Controllers\Admin\OrderStatusChangeController::class,
            'add_note' => \Mtc\Orders\Http\Controllers\Admin\OrderNoteController::class,
            'dispatch_note' => \Mtc\Orders\Http\Controllers\Admin\OrderDispatchController::class,
            'send_confirmation' => \Mtc\Orders\Http\Controllers\Admin\OrderConfirmationController::class,
            'bulk_process' => \Mtc\Orders\Http\Controllers\Admin\OrderBulkProcessController::class,
            'shipment_controller' => ShipmentController::class,
        ]
    ],

    'manual_order_basket_builder' => \Mtc\Orders\ManualOrderBasketBuilder::class,
    'create_invoice_when_editing_order' => true,
    'order_amend_invoice_factory' => \Mtc\Orders\Factories\OrderAmendInvoiceFactory::class,

    /*
    |--------------------------------------------------------------------------
    | Assign order to a manager
    |--------------------------------------------------------------------------
    |
    | Enable / disable ability to assign user to a manager
    |
    */

    'assign_to_admin' => false,
    'assign_to_admin_role' => 'Administrator',

    /*
    |--------------------------------------------------------------------------
    | Order printables
    |--------------------------------------------------------------------------
    |
    | Toggle whether printing dispatch note and picking list actions are shown in admin
    |
    */

    'show_print_dispatch_note' => true,
    'show_shipment_picking_list' => true,


    /*
    |--------------------------------------------------------------------------
    | Admin search filters
    |--------------------------------------------------------------------------
    |
    | Classes that will implement search filters on order admin list page
    | Each class is expected to follow the format of AdminFilter interface
    |
    */

    'admin_search_filters' => [
        \Mtc\Orders\Filters\FilterById::class,
        \Mtc\Orders\Filters\FilterByStatus::class,
        \Mtc\Foundation\Filters\FilterByEmail::class,
        \Mtc\Foundation\Filters\FilterByMemberId::class,
        \Mtc\Orders\Filters\FilterByCustomerName::class,
        \Mtc\Orders\Filters\FilterByDateFrom::class,
        \Mtc\Orders\Filters\FilterByDateTo::class,
        \Mtc\Orders\Filters\FilterByPostalCode::class,
        \Mtc\Orders\Filters\FilterByCountry::class,
        \Mtc\Orders\Filters\FilterByManager::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Printable templates
    |--------------------------------------------------------------------------
    |
    | Set a custom template for dispatch notes / picking list
    |
    */
    'despatch_note_template' => 'admin/orders/despatch_note.twig',
    'picking_list_template' => 'admin/orders/picking_list.twig',

    /*
    |--------------------------------------------------------------------------
    | Shipment Creation from order page
    |--------------------------------------------------------------------------
    |
    | This setting links to shipment creation from view order page
    |
    */
    'shipment_creation' => true,
    'manual_shipment_value' => false,
    'shipment_factory' => \Mtc\Orders\Factories\ShipmentFactory::class,
    'shipment_packaging_layout' => 'basic',
    'shipment_export_controller' => \Mtc\ShippingManager\Http\Controllers\Admin\BasicShipmentExportController::class,

    /*
    |--------------------------------------------------------------------------
    | Shipment Reference
    |--------------------------------------------------------------------------
    |
    | Create an invokable class for custom reference on shipment.
    | Alternatively id will be used
    |
    */

    'shipment_reference_builder' => null,

    /*
    |--------------------------------------------------------------------------
    | Status Emails - Replacements and default template
    |--------------------------------------------------------------------------
    |
    | Define replacement blocks and what field they represent.
    | Can use other config names as well.
    |
    | Date format is used for date columns
    | Default template will be used unless something else will be chosen when
    | creating a new email status
    |
    */
    'status_replacements' => [
        'CUSTOMER_FIRST_NAME' => 'billingAddress.first_name',
        'STATUS' => 'status.name',
        'ORDER_DATE' => 'paid_at',
        'ORDER_ID' => 'id',
        'SITE_NAME' => 'app.name'
    ],

    'status_replacement_date_format' => 'l jS F Y',
    'status_default_email_template' => '/emails/orders/order_email.twig',

    /*
    |--------------------------------------------------------------------------
    | Auto-capture deferred payments
    |--------------------------------------------------------------------------
    |
    | This config allows auto-capturing payments on specific status.
    | This will only work if status is set and checkout.deferred_payments
    | config is enabled.
    |
    | Set this value to status id on which to perform capture.
    |
    */

    'auto_capture_deferred_payments_on_status' => false,

    /*
    |--------------------------------------------------------------------------
    | Tracking info fields
    |--------------------------------------------------------------------------
    |
    | If site doesn't use courier API and shipment management a simple
    | interface is offered for managing tracking information.
    | This config allows setting fields that would be available in admin.
    | When set they are saved to order.tracking_data and are available in templates.
    |
    */
    'tracking_fields' => [
        [
            'name' => 'courier',
            'type' => 'select',
            'label' => 'Courier',
            'values' => [
                'dpd' => 'DPD',
                'dhl' => 'DHL',
                'ups' => 'UPS',
            ],
        ],
        [
            'name' => 'code',
            'type' => 'text',
            'label' => 'Tracking Code',
        ],
    ],
];
