<?php

namespace Mtc\Orders\Events;

use Illuminate\Queue\SerializesModels;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Mtc\Orders\Contracts\OrderContract;

class FetchOrderProcessingActions
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * @var OrderContract
     */
    protected $order;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(OrderContract $order)
    {
        $this->order = $order;
    }

    /**
     * @return OrderContract
     */
    public function getOrder()
    {
        return $this->order;
    }

}
