import store from '../../store';

store.registerModule('order', {
    state: {
        order: {},
    },
    getters: {
        isLoaded: state => {
            return Object.keys(state.order).length > 0;
        }
    },
    mutations: {
        setOrder(state, order) {
            state.order = order;
        },
        createNewProduct(state) {
            state.order.items.push({
                name: '',
                sku: '',
                node_id: '',
                paid_price: 0,
                quantity: 0,
                percentage_discount: 0,
                amount_discount: 0,
                modified: true,
                deleted: false,
                modify_price: false,
                modify_product: true
            });
        }
    },
    actions: {
        updateOrder(context, order) {
            context.commit('setOrder', order);
        },
        addProduct(context) {
            context.commit('createNewProduct');
        }
    }
});
