<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddQuantityOnBackorderToOrderItems extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->decimal('backorder_cost_total', 10)->after('cost_total')->nullable();
        });

        Schema::table('order_items', function (Blueprint $table) {
            $table->integer('quantity_on_backorder')->after('quantity')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn('backorder_cost_total');
        });

        Schema::table('order_items', function (Blueprint $table) {
            $table->dropColumn('quantity_on_backorder');
        });
    }
}
