<?php

namespace Mtc\Orders\Listeners;

use Illuminate\Support\Facades\URL;
use Mtc\Orders\Events\FetchOrderProcessingActions;
use Mtc\Orders\Events\OrderPaid;

/**
 * Class ViewOrderSuccessPage
 *
 * @package Mtc\Orders
 */
class ViewOrderSuccessPage
{
    /**
     * Handle the event.
     *
     * @param OrderPaid $event
     * @return array
     */
    public function handle(FetchOrderProcessingActions $event)
    {
        $invoice_id = optional($event->getOrder()->invoices()->first())->id;
        if ($invoice_id) {
            return [
                'name' => 'View Order Confirmation Page',
                'action' => URL::signedRoute('successful_payment', ['id' => $invoice_id], null, config('app.env') === 'production'),
                'method' => 'get'
            ];
        }
    }

}
