<?php

namespace Mtc\Orders\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class AdminOrderAjax
 *
 * @package Mtc\Orders\Http\Resources
 */
class AdminOrderAjax extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $this->resource->load([
            'billingAddress',
            'shippingAddress',
            'collectionAddress',
            'discounts',
            'surcharges',
            'items.lines',
            'items.purchasable',
        ]);

        $this->resource->items
            ->each(function ($item) {
                $item->modified = false;
                $item->deleted = false;
                $item->modify_product = false;
                $item->modify_price = false;
                $item->editable = $item->shipmentItems()->exists() == false;
            });

        return parent::toArray($request);
    }
}
