<?php

namespace Mtc\Orders\Listeners;

use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Mtc\Orders\Events\FetchOrderProcessingActions;

class PrintInvoiceAction
{
    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return null|array
     */
    public function handle(FetchOrderProcessingActions $event)
    {
        if ($this->shouldShowAction($event->getOrder()) == false) {
            return null;
        }

        $invoice = $event->getOrder()
            ->invoices()
            ->latest()
            ->first();

        if (!$invoice) {
            return null;
        }

        return [
            'name' => __('orders::orders.print_invoice'),
            'action' => route('invoices.show', [ $invoice->id ]),
            'method' => 'get'
        ];
    }

    /**
     * Check if invoice
     * @param $order
     * @return \Illuminate\Config\Repository|mixed
     */
    protected function shouldShowAction($order)
    {
        return empty(config('orders.only_show_print_invoice_on_statuses', []))
            || in_array($order->status_id, config('orders.only_show_print_invoice_on_statuses', []));
    }
}
