<?php

namespace Mtc\Orders\Listeners;

use Illuminate\Support\Facades\Auth;
use Mtc\Orders\Order;
use Mtc\Refunds\Events\RefundCreated;

/**
 * Class UpdateOrderStatusOnRefund
 *
 * @package Mtc\Orders
 */
class UpdateOrderStatusOnRefund
{
    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return void
     */
    public function handle(RefundCreated $event)
    {
        if ($event->refund->invoice->payable_type !== 'order') {
            return;
        }

        /** @var Order $order */
        $order = $event->refund->invoice->payable;

        if ($order->cost_total->raw(true) - $event->refund->amount < 0.01) {
            $order->changeStatus(config('orders.statuses.refunded'), Auth::user());
        } else {
            $order->changeStatus(config('orders.statuses.part-refunded'), Auth::user());
        }
    }
}
