<?php

namespace Mtc\Orders\Console\Commands;

use Illuminate\Console\Command;
use Mtc\Orders\Providers\OrderServiceProvider;
use Mtc\Orders\Seeds\OrderSeeder;

/**
 * Class InstallOrderManagement
 *
 * @package Mtc\ShippingManager
 */
class InstallOrderManagement extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'install:orders';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Install Order Manager default assets/data';

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        $this->info('Installing Shipping Manager');
        $this->callSilent('migrate');

        $this->callSilent('vendor:publish', [
            '--provider' => OrderServiceProvider::class,
            '--tag' => 'assets',
        ]);

        $this->comment('Setting up database');
        $this->call('db:seed', [
            '--class' => OrderSeeder::class
        ]);

        $this->info('Shipping Manager installed successfully.');
    }
}
