<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddExVatColumnsToOrders extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->decimal('cost_subtotal_ex_vat', 10)->after('cost_subtotal')->nullable();
            $table->decimal('cost_total_ex_vat', 10)->after('cost_total')->nullable();
            $table->decimal('cost_subtotal', 10)->nullable()->change();
            $table->decimal('cost_total', 10)->nullable()->change();
            $table->boolean('use_ex_vat')->default(0)->after('vat_value');
        });

        Schema::table('order_discounts', function (Blueprint $table) {
            $table->decimal('discount_amount_ex_vat', 10)->after('discount_amount')->nullable();
            $table->decimal('discount_amount', 10)->nullable()->change();
        });

        Schema::table('order_surcharges', function (Blueprint $table) {
            $table->decimal('surcharge_amount_ex_vat', 10)->after('surcharge_amount')->nullable();
            $table->decimal('surcharge_amount', 10)->nullable()->change();
        });

        Schema::table('order_items', function (Blueprint $table) {
            $table->decimal('unit_price_ex_vat', 10)->after('unit_price')->nullable();
            $table->decimal('paid_price_ex_vat', 10)->after('paid_price')->nullable();
            $table->decimal('unit_price', 10)->nullable()->change();
            $table->decimal('paid_price', 10)->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn('cost_subtotal_ex_vat');
            $table->dropColumn('cost_total_ex_vat');
            $table->dropColumn('use_ex_vat');
        });

        Schema::table('order_discounts', function (Blueprint $table) {
            $table->dropColumn('discount_amount_ex_vat');
        });

        Schema::table('order_surcharges', function (Blueprint $table) {
            $table->dropColumn('surcharge_amount_ex_vat');
        });

        Schema::table('order_items', function (Blueprint $table) {
            $table->dropColumn('unit_price_ex_vat');
            $table->dropColumn('paid_price_ex_vat');
        });
        Schema::table('invoice_lines', function (Blueprint $table) {
            $table->dropColumn('value_ex_vat');
        });
    }
}
