<?php

namespace Mtc\Orders\Listeners;

use Mtc\Orders\Events\OrderStatusChange;
use Mtc\Orders\Jobs\CaptureDeferredPayment;

/**
 * Class AttemptDeferredPaymentCapture
 *
 * @package Mtc\Orders
 */
class AttemptDeferredPaymentCapture
{
    /**
     * Handle the event.
     *
     * @return void
     */
    public function handle(OrderStatusChange $event)
    {
        if ($event->getStatus() !== config('orders.auto_capture_deferred_payments_on_status')) {
            // Not the relevant status
            return;
        }
        $event->getOrder()
            ->invoices()
            ->where('status', 0)
            ->get()
            ->each(function ($invoice) {
                $invoice->payments
                    ->each(function ($payment) {
                        if ($payment->confirmed_at) {
                            return;
                        }
                        dispatch(new CaptureDeferredPayment($payment));
                    });
            });

    }
}
