<?php

namespace Mtc\Orders\Seeds;

use Illuminate\Database\Seeder;

class OrderStatusSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->getData())
            ->each(function ($entry) {
                \Mtc\Orders\OrderStatus::query()
                    ->updateOrCreate([
                        'id' => $entry['id']
                    ], $entry);
            });
    }

    /**
     * seed data
     *
     * @return array
     */
    protected function getData()
    {
        return [
            [
                'id' => 1,
                'colour_code' => 'badge-primary',
                'name' => 'Order Received',
                'send_email_on_status' => 1,
                'email_template_path' => '/emails/orders/order_email.twig',
                'email_subject' => 'Your {{SITE_NAME}} Order',
                'email_text' => '<p>Hi <strong>{{CUSTOMER_FIRST_NAME}}</strong>,</p><p><strong>Your order is confirmed! </strong></p><p>Thank you for your online order placed on <strong>{{ORDER_DATE}}</strong>!</p>',
                'is_failure_status' => 0,
                'active' => 1,
            ],
            [
                'id' => 2,
                'colour_code' => 'badge-warning',
                'name' => 'On Picking',
                'send_email_on_status' => 0,
                'email_template_path' => '',
                'email_subject' => '',
                'email_text' => '',
                'is_failure_status' => 0,
                'active' => 0,
            ],
            [
                'id' => 3,
                'colour_code' => 'badge-success',
                'name' => 'Shipped',
                'send_email_on_status' => 1,
                'email_subject' => 'Your {{SITE_NAME}} Order is Shipped',
                'email_template_path' => '/emails/orders/shipment_email.twig',
                'email_text' => '<p>Hi <strong>{{CUSTOMER_FIRST_NAME}}</strong>,</p><p>Your order #{{ORDER_ID}} has been shipped!</p>',
                'is_failure_status' => 0,
                'active' => 1,
            ],
            [
                'id' => 4,
                'colour_code' => 'badge-info',
                'name' => 'Part Shipped',
                'send_email_on_status' => 0,
                'email_template_path' => '',
                'email_text' => '',
                'is_failure_status' => 0,
                'active' => 0,
            ],
            [
                'id' => 5,
                'colour_code' => 'badge-danger',
                'name' => 'Part Refunded',
                'send_email_on_status' => 0,
                'email_template_path' => '',
                'email_text' => '',
                'is_failure_status' => 0,
                'active' => 0,
            ],
            [
                'id' => 6,
                'colour_code' => 'badge-dark',
                'name' => 'Refunded',
                'send_email_on_status' => 1,
                'email_template_path' => '/emails/orders/refund.twig',
                'email_subject' => 'Your {{SITE_NAME}} Order Refund',
                'email_text' => '<p>Hi <strong>{{CUSTOMER_FIRST_NAME}}</strong>,</p><p>Your order #{{ORDER_ID}} has been refunded.</p>',
                'is_failure_status' => 0,
                'active' => 1,
            ],
            [
                'id' => 7,
                'colour_code' => 'badge-primary',
                'name' => 'Waiting For Response',
                'send_email_on_status' => 0,
                'email_template_path' => '',
                'email_text' => '',
                'is_failure_status' => 0,
                'active' => 0,
            ],
            [
                'id' => 8,
                'colour_code' => 'badge-dark',
                'name' => 'Cancelled',
                'send_email_on_status' => 0,
                'email_template_path' => '',
                'email_text' => '',
                'is_failure_status' => 1,
                'active' => 0,
            ],
        ];
    }
}
