<?php

namespace Mtc\Orders\Listeners;

use Mtc\Orders\Events\OrderPaid;

/**
 * Class DeductStockOnPaidOrder
 *
 * @package Mtc\Orders\Listeners
 */
class DeductStockOnPaidOrder
{
    /**
     * Handle the event.
     *
     * @param  OrderPaid $event
     * @return void
     */
    public function handle(OrderPaid $event)
    {
        if (config('orders.deduct_stock_after_order_is_paid', false) === false) {
            return;
        }

        $order = $event->getOrder();
        $order->items
            ->each(function ($order_item) {
                if (isset($order_item->purchasable->stock)) {
                    $order_item->purchasable->decrement('stock', $order_item->quantity);
                }
            });
    }
}
