<?php

use Mtc\Orders\Http\Controllers\Admin\OrderActionController;
use Mtc\Orders\Http\Controllers\Admin\OrderShipmentBoxController;
use Mtc\Orders\Http\Controllers\Admin\ShipmentController;
use Illuminate\Routing\Router;
use Mtc\Orders\Http\Controllers\Admin\OrderController;
use Mtc\Orders\Http\Controllers\Admin\StatusController;
use Mtc\Orders\Http\Controllers\Admin\ShipmentBoxController;

$router->group([
    'prefix' => '/admin',
    'middleware' => [
        'auth'
    ]
], function (Router $router) {
    $router->post('orders/{id}/add-note', config('orders.admin.routing.add_note'))->name('orders.add-note');
    $router->get('orders/{id}/despatch-note', config('orders.admin.routing.dispatch_note'))->name('orders.dispatch');
    $router->post('orders/{id}/send-confirmation', config('orders.admin.routing.send_confirmation'))->name('orders.send_confirmation');
    $router->post('orders/{id}/status/{status_id}', config('orders.admin.routing.set_status'))->name('order.set_status');
    $router->post('orders/bulk-process', config('orders.admin.routing.bulk_process'))->name('orders.bulk_process');
    $router->delete('orders/flush', [OrderController::class, 'flush'])->name('orders.flush');
    $router->get('orders/unpaid', [OrderController::class, 'unpaid'])->name('orders.unpaid');
    $router->resource('orders', OrderController::class);
    $router->resource('orders/{id}/shipment', config('orders.admin.routing.shipment_controller'));
    $router->get('orders/{order}/shipment/{shipment}/picking_list', [config('orders.admin.routing.shipment_controller'), 'pickingList'])->name('shipment.picking_list');
    $router->put('orders/{order}/shipment/{shipment}/complete', [config('orders.admin.routing.shipment_controller'), 'complete'])->name('shipment.mark_complete');
    $router->resource('order-statuses', StatusController::class)->except(['destroy']);
    $router->get('order-emails', [StatusController::class, 'list']);

    $router->group([
        'as' => 'order.',
    ], function (Router $router) {
        $router->resource('/shipment/{shipment}/shipment-boxes', OrderShipmentBoxController::class);
    });
    $router->resource('shipment-boxes', ShipmentBoxController::class);
});

